var network = null;
var menuApp = new Vue(
{ el: '#app'
, data: function() {
    return { root: null
           , icon: null
           , bookmark: null
           , search: ''
           , breadcrumbs: []
           , exercise: { daysIdle: -1, mode: 'loading' }
           , events: null
           };
  }
, methods: {
    'revealChart': function() {
      if ( this.exercise.mode != 'chart' ) {
        this.exercise.mode = 'chart';
      }
    },
    'reset': function() {
		  $('body').removeClass('discourage');
      this.bookmark = this.root;
      this.search = '';
      this.breadcrumbs = [];
    },
    'initReset': function(data) {
      if (this.root != null) {
        this.reset();
      }
    },
    'catchMenu': function(data) {
      this.root = data;
      this.initReset();
      this.traverseMenu();
    },
    'catchClick': function(keyCode) {
      this.catchKey({ 'key': keyCode });
    },
    'triggerSearch': function() {
      var e = jQuery.Event('keyup');
      e.code = 'Enter';
      $('#searchControl input').trigger(e);
    },
    'goTo': function(url) {
      $('body').fadeOut(1000, function() {
        window.location = url;
      });
    },
    'catchKey': function(e) {
      if (e.code == 'KeyM' && e.ctrlKey) {
        e.preventDefault();
        var menu = window.prompt('Which menu would you like to use instead?');
        if ( menu != null ) {
          localStorage['menu'] = menu.toUpperCase();
          window.location.reload();
        }
      } else if (e.code == 'KeyA' && e.ctrlKey && e.altKey) {
        if ( window.localStorage.disableMenuAnimation == undefined ) {
          window.localStorage.disableMenuAnimation = true;
        } else {
          delete window.localStorage.disableMenuAnimation;
        }
      } else if (e.code == 'Enter') {
        var url = null;
        if (this.bookmark.search != undefined) {
          url = this.bookmark.search;
          url = url.replace('{term}', this.search);
        } else if (this.bookmark.url != undefined) {
          url = this.bookmark.url;
        }
        if (url != null) {
          this.goTo(url);
        }
      } else if (e.code == 'Escape') {
        this.reset();
      } else if (this.bookmark[e.key.toLowerCase()] != undefined) {
        if (this.bookmark[e.key.toLowerCase()].label != undefined) {
					if ( Object.keys(this.bookmark[e.key.toLowerCase()]).indexOf('discourage') != -1 ) {
					  $('body').addClass('discourage');
          }
          this.breadcrumbs.push(e.key.toLowerCase());
        }
        if (this.bookmark[e.key.toLowerCase()].menu != undefined) {
          this.bookmark = this.bookmark[e.key.toLowerCase()].menu;
          this.traverseMenu(this.bookmark, this.breadcrumbs);
        } else {
          this.bookmark = this.bookmark[e.key.toLowerCase()];
          this.$nextTick(() => {
            if (this.bookmark.search != undefined) {
              $('#searchControl input').focus();
            } else if (this.bookmark.url != undefined) {
              this.goTo(this.bookmark.url);
            }
          })
        }
      }
    },
    'createNode': function(id, label, image) {
      var n = { 'id': id, font: "42px courier" }
      if ( image != undefined && this.icon) {
        n.image = this.iconSrc(image);
        n.shape = 'circularImage';
        n.size = 50;
        n.shapeProperties = {
          useImageSize: false,
          useBorderWithImage: true,
          coordinateOrigin: "center",
        };
      } else {
        n.label = label.toUpperCase();
      }
    },
    'linkNodes': function(lhs, rhs) {
      var e = { 'from': lhs, 'to': rhs, length: 150, width: 5 };
      e.arrows = { to: { enabled: true, type: 'arrow', size: 50 } };
    },
    'traverseMenu': function( parent = null, path = undefined ) {
      var node = ( parent == null ? this.root : parent );
      var path = ( parent == null ? [] : path );
      for ( var idx in node ) {
        var lhs = JSON.parse(JSON.stringify(path));
        lhs.unshift('0');
        var rhs = JSON.parse(JSON.stringify(lhs));
        rhs.push(idx);
        // if ( node[idx].menu != undefined ) {
        //   var subpath = rhs;
        //   subpath.shift();
        //   this.traverseMenu(node[idx].menu, subpath);
        // }
      }
    },
    'iconSrc': function( key ) {
      return this.icon[key];
    },
    'daysAway': function(dt) {
      var ret = moment(dt).diff(moment(), 'days') + 1;
      return ret;
    },
    'formatDate': function(dt) {
      return moment(dt).format("DD MMM YYYY");
    }
  }
, mounted: function() {
    var mode = ( new Date() ).getHours();
    mode = ( mode >= 6 && mode < 18 ? 'day' : 'night' );
    this.icon = jQuery.ajax({ 'url': 'icon.json', 'async': false }).responseJSON;
    var fname = ( localStorage.menu != undefined ? 'index-' + localStorage.menu + '.json' : 'index.json' );
    jQuery.ajax({ 'url': fname, 'success': this.catchMenu, });
    $('body').addClass(mode);
    $('body').fadeIn();
  }
});
function isMobile() {
  const userAgent = navigator.userAgent || navigator.vendor || window.opera;
  // $('#ua').html(userAgent);
  const isMobileDevice = /Mobi|Android/i.test(userAgent);
  //const isSmallScreen = window.innerWidth <= 1000;
  //return isMobileDevice || isSmallScreen;
  return isMobileDevice;
}
$().ready(function() {
  $('body').keyup(menuApp.catchKey);
  if ( isMobile() ) {
    $('body').addClass('mobile');
  } else {
    var payload1 = {};
    payload1.method  = 'GET';
    payload1.url     = 'https://grafana.downie.net.au/public-dashboards/d7b9dde2e9ba44ad8e1477147dcd511b?orgId=1';
    payload1.success = function(data, textStatus, jqXHR) {
      var iframe = $('<iframe/>').attr('src', payload1.url);
      $('#exercise .chart').append(iframe);
    }
    payload1.error = function(jqXHR, textStatus, errorThrown) {
      console.log('Bummer, Grafana doesn\'t appear to be available.');
      console.log('ERROR', jqXHR.status);
    }
    jQuery.ajax(payload1);

    var payload2 = {};
    payload2.method  = 'GET';
    payload2.url = 'https://incubator.downie.net.au/dotnetAPI/Exercise/DaysIdle';
    payload2.success = function(data, textStatus, jqXHR) {
      var di = parseInt(data);
      menuApp.exercise.daysIdle = di;
      // This is my hack to disable this feature until i start exercising again...
      menuApp.exercise.mode = 'ignore';
      //menuApp.exercise.mode = 'badge';
    }
    payload2.error = function(jqXHR, textStatus, errorThrown) {
      menuApp.exercise.mode = 'offline';
      console.log('Failure');
    }
    jQuery.ajax(payload2);

    var payload3 = {};
    payload3.method  = 'GET';
    payload3.url = 'https://incubator.downie.net.au/dotnetAPI/Events/Get';
    payload3.success = function(data, textStatus, jqXHR) {
      menuApp.events = data;
    }
    payload3.error = function(jqXHR, textStatus, errorThrown) {
      console.log('Failure');
    }
    jQuery.ajax(payload3);
  }
});
